/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.anims;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class FallAtkLoopAnim
extends ActionAnimation {
    private StaticAnimation atk;

    public FallAtkLoopAnim(float convertTime, String path, Armature model, StaticAnimation atk) {
        super(convertTime, path, model);
        this.atk = atk;
        this.addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.addProperty(ClientAnimationProperties.PRIORITY, Layer.Priority.HIGHEST);
        }
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, 0.0, 0.0);
        ((LivingEntity)entitypatch.getOriginal()).m_6478_(MoverType.SELF, new Vec3(0.0, -2.0, 0.0));
        if (!entitypatch.isLogicalClient() && this.shouldAtk(entitypatch)) {
            entitypatch.playAnimationSynchronized(this.atk, 0.0f);
        }
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
    }

    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        ((LivingEntity)entitypatch.getOriginal()).m_20334_(0.0, -2.0, 0.0);
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
    }

    private boolean castGround(LivingEntity entity, float length, Vec3 offset) {
        Vec3 epos = entity.m_20182_();
        ClipContext clipContext = new ClipContext(epos.m_82549_(offset), epos.m_82549_(offset).m_82520_(0.0, (double)(-length), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity);
        BlockHitResult result = entity.m_9236_().m_45547_(clipContext);
        return result.m_6662_() == HitResult.Type.BLOCK;
    }

    private boolean shouldAtk(LivingEntityPatch<?> entitypatch) {
        return this.castGround((LivingEntity)entitypatch.getOriginal(), 4.3f, new Vec3(0.3, 1.0, 0.3)) || this.castGround((LivingEntity)entitypatch.getOriginal(), 4.3f, new Vec3(-0.3, 1.0, 0.3)) || this.castGround((LivingEntity)entitypatch.getOriginal(), 4.3f, new Vec3(-0.3, 1.0, -0.3)) || this.castGround((LivingEntity)entitypatch.getOriginal(), 4.3f, new Vec3(0.3, 1.0, -0.3));
    }

    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        float patchedTime = time % this.getTotalTimeReal();
        return super.getPoseByTime(entitypatch, patchedTime, partialTicks);
    }

    private float getTotalTimeReal() {
        return super.getTotalTime();
    }

    public float getTotalTime() {
        return Float.MAX_VALUE;
    }

    public void linkTick(LivingEntityPatch<?> entitypatch, DynamicAnimation linkAnimation) {
        super.linkTick(entitypatch, linkAnimation);
    }
}

